
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1009.C - Message 1009 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1009 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1009.C_v  $
//   
//      Rev 1.15   09 Nov 1998 10:25:50   phungh
//   labmon51: Fix file logging and missing 
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of
//   time spent too long in the interrupt handler
//   
//      Rev 1.5   Jul 09 1997 10:36:12   COLEJ
//    
//   
//      Rev 1.4   Feb 12 1997 16:05:16   COLEJ
//    
//   
//      Rev 1.3   Aug 26 1996 18:42:52   COLEJ
//    
//   
//      Rev 1.2   Aug 19 1996 17:12:02   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:17:00   COLEJ
//   Deleted UTCNSECS field and processing, and moved up other fields.
//   Changed GPS field to display GPSSEC.
//   Added msg1108 coditional processing of UTC TIME
//   
//      Rev 1.0   13 May 1996 14:52:40   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "util.h" 
#include "display.h"
 
extern tBOOL DisplayDRError;

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1009 message from the ZMsgBuf.
//
void Dec1009(tMSGBUF *ZMsgBuf, tMSG1009 *Msg)
{  
   // tbd
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1009 message in the ZMsgBuf. 
//
void Bld1009(tMSGBUF *ZMsgBuf, tMSG1009 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                       , ZMsgBuf,  1);      // message preamble
   PutShort  (1001                         , ZMsgBuf,  2);      // message number
   PutShort  (47                           , ZMsgBuf,  3);      // message length 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1009 message from the ZMsgBuf.
//
void Show1009(tMSG1009 *Msg)
{
   char    Buf[80] = "";

   if (!DisplayDRError) {
   // output the data items   
   sprintf(Buf,"%05d"  ,Msg->SequenceNumber          );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%05d"  ,Msg->MeasSequenceNumber      );ShowText(Buf,TIMR+ 6,TIMC+12);
   sprintf(Buf,"%10.1f",Msg->ECEFPositionX     /1E+02);ShowText(Buf,POSR   ,POSC+ 6);
   sprintf(Buf,"%10.1f",Msg->ECEFPositionY     /1E+02);ShowText(Buf,POSR+ 1,POSC+ 6);
   sprintf(Buf,"%10.1f",Msg->ECEFPositionZ     /1E+02);ShowText(Buf,POSR+ 2,POSC+ 6);  
   sprintf(Buf,"%6.2f" ,Msg->ECEFVelocityX     /1E+02);ShowText(Buf,VELR   ,VELC+ 4); 
   sprintf(Buf,"%6.2f" ,Msg->ECEFVelocityY     /1E+02);ShowText(Buf,VELR+ 1,VELC+ 4); 
   sprintf(Buf,"%6.2f" ,Msg->ECEFVelocityZ     /1E+02);ShowText(Buf,VELR+ 2,VELC+ 4); 
   }
   
}                                                 
                                      
                                           
